<?php

namespace Database\Seeders;

use App\Models\Doctor;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DoctorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $doctors = [
            [
                'name' => 'Dr. Yogesh Neupane',
                'specialization' => 'Otolaryngologist & Head Neck Surgeon',
                'credentials' => 'MBBS, MS, Fellowship in Snoring & Sleep Apnea Surgery. NMC No.: 4861',
                'bio' => 'Experienced Otolaryngologist specializing in sleep apnea and snoring disorders.',
                'experience_years' => 12,
                'is_active' => true,
            ],
            [
                'name' => 'Dr. Deepak Yadav',
                'specialization' => 'Head and Neck Oncology',
                'credentials' => 'MBBS (BPKISH), MS (TU), Fellowship in Head and Neck Oncology (TMH, Mumbai). NMC No.: 6595',
                'bio' => 'Specialist in Head and Neck Oncology with advanced training from TMH, Mumbai.',
                'experience_years' => 10,
                'is_active' => true,
            ],
            [
                'name' => 'Dr. Rishi Bhatta',
                'specialization' => 'ENT-Head & Neck Surgeon',
                'credentials' => 'MBBS (KU), MS (TU) Gold Medalist, Fellowship in Rhinology and Skull Base Surgery (Canada). NMC No.: 5382',
                'bio' => 'Gold Medalist surgeon specializing in Rhinology and Skull Base Surgery.',
                'experience_years' => 14,
                'is_active' => true,
            ],
            [
                'name' => 'Dr. Sahara Adhikari',
                'specialization' => 'ENT-Head and Neck Surgery',
                'credentials' => 'MBBS (CTGU), MS (HUM). NMC No.: 11294',
                'bio' => 'Dedicated ENT-Head and Neck Surgeon committed to patient care.',
                'experience_years' => 8,
                'is_active' => true,
            ],
            [
                'name' => 'Ms. Ranjana Bhasima',
                'specialization' => 'Audiologist and Speech Language Pathologist',
                'credentials' => 'ASLP. NHPC A - 27',
                'bio' => 'Expert Audiologist and Speech Language Pathologist helping patients with communication disorders.',
                'experience_years' => 7,
                'is_active' => true,
            ],
            [
                'name' => 'Dr. Prasan Shrestha',
                'specialization' => 'ENT Head & Neck Surgeon',
                'credentials' => 'MBBS, MS(KU). NMC No.: 16612',
                'bio' => 'Skilled ENT Head & Neck Surgeon providing comprehensive care.',
                'experience_years' => 6,
                'is_active' => true,
            ],
            [
                'name' => 'Dr. Rabindra Bhakta Pradhananga',
                'specialization' => 'ENT-Head & Neck Surgeon',
                'credentials' => 'MBBS (KU)/MS (TU), Fellowship in Implantation Otology. NMC No.: 3088',
                'bio' => 'Specialized in Implantation Otology and Cochlear Implant Surgery.',
                'experience_years' => 18,
                'is_active' => true,
            ],
            [
                'name' => 'Dr. Arun K. C.',
                'specialization' => 'Consultant ENT Surgeon',
                'credentials' => 'MBBS, MS, Fellowship in Laryngology (Royal College of Surgeons, England). NMC No.: 6414',
                'bio' => 'Consultant ENT Surgeon with international fellowship in Laryngology.',
                'experience_years' => 11,
                'is_active' => true,
            ],
            [
                'name' => 'Dr. Dipesh Shakya',
                'specialization' => 'ENT-Head & Neck Surgeon',
                'credentials' => 'MD, MS, Fellowship in Otology (Japan). NMC No.: 8567',
                'bio' => 'ENT-Head & Neck Surgeon with specialized training in Otology from Japan.',
                'experience_years' => 9,
                'is_active' => true,
            ],
            [
                'name' => 'Dr. Sonu Kumar Yadav',
                'specialization' => 'ENT-Head and Neck Surgeon',
                'credentials' => 'MBBS (PAHS), MS (KU, NMCTH). NMC No.: 21279',
                'bio' => 'ENT-Head and Neck Surgeon dedicated to serving the community.',
                'experience_years' => 5,
                'is_active' => true,
            ],
            [
                'name' => 'Ms. Preeti Chaudhary',
                'specialization' => 'Consultant Audiologist',
                'credentials' => 'NHPC-A-56 Sp & Hg',
                'bio' => 'Consultant Audiologist specializing in hearing diagnostics and rehabilitation.',
                'experience_years' => 6,
                'is_active' => true,
            ],
        ];

        foreach ($doctors as $doctor) {
            Doctor::create($doctor);
        }
    }
}
